# OpenCart ↔ QuickBooks Web Connector (QBWC) — Starter Pack

This folder gives you a **minimal, working** SOAP service so QuickBooks Web Connector can connect without errors.
It intentionally returns **no work**; once you confirm handshakes are clean, plug in your invoice export logic.

## What this fixes
- **`Couldn't find <definitions>`** → We include a valid WSDL at `wsdl/QBWebConnectorSvc.wsdl`.
- **`text/html; expected text/xml`** → `qbwc_server.php` never echoes HTML on errors and logs to `logs/qbwc.log`.
- **Certificate errors (QBWC1048/C1051)** → Ensure your **HTTPS** URL in `.qwc` and `config.php` matches the certificate's domain *exactly*, and that your server serves the **full chain** (certificate + intermediate).
  - In cPanel: SSL/TLS → Install and Manage SSL → Make sure the **CABUNDLE** field is populated (Let's Encrypt provides it).
  - Test with SSL Labs. Old Windows machines must trust `ISRG Root X1` (Let's Encrypt). Install recent Windows root updates.

## Quick start
1. Upload the **`qbwc-bridge`** folder to your site (HTTPS), e.g. `https://YOURDOMAIN/qbwc-bridge/`.
2. Make sure `qbwc-bridge/logs/` is **writable** by PHP (755 or 775).
3. Edit `qbwc-bridge/config.php`:
   - Set `QBWC_USERNAME`, `QBWC_PASSWORD`
   - Set `APP_URL` to your HTTPS service URL
   - Fill your MySQL creds and OpenCart prefix
   - Keep `WSDL_ABS` as is
4. Edit `OpenCart_QB_Bridge.qwc` and set both `AppURL` and `AppSupport` to the same HTTPS domain.
5. On the QB machine, open **QuickBooks Web Connector** → Add an application → select the `.qwc` file.
6. Enter the same **username/password** from config, grant access in QuickBooks, click **Update Selected**.
7. Review `qbwc-bridge/logs/qbwc.log` if anything fails.

## Next steps — exporting OpenCart orders as Invoices
- Implement your queue in `sendRequestXML()` and `receiveResponseXML()` (marked TODO).
- Typical flow per order:
  1) `CustomerQueryRq` → if not found → `CustomerAddRq`
  2) `ItemQueryRq` for each product → add as `ItemServiceAddRq` (or `ItemInventoryAddRq`) if missing
  3) `InvoiceAddRq` with line items, taxes, shipping
  4) Mark the order in `oc_qbwc_export`

This starter only focuses on **stability** so you can sort out certificate/WSDL problems first.
